using System;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        long[] x = new long[n];
        long[] h = new long[n];
        
        string[] xParts = Console.ReadLine().Split();
        for (int i = 0; i < n; i++)
            x[i] = long.Parse(xParts[i]);
        
        string[] hParts = Console.ReadLine().Split();
        for (int i = 0; i < n; i++)
            h[i] = long.Parse(hParts[i]);

        for (int i = 0; i < n; i++)
        {
            long best = long.MaxValue;

            for (int j = 0; j < n; j++)
            {
                if (j != i)
                {
                    if (h[j] >= h[i])
                    {
                        long dist = x[j] - x[i];
                        if (dist < 0) dist = -dist;
                        
                        if (dist < best)
                            best = dist;
                    }
                }
            }

            for (int j = 0; j < n - 1; j++)
            {
                long xa = x[j];
                long xb = x[j + 1];
                long ha = h[j];
                long hb = h[j + 1];
                
                long x1, x2, h1, h2;
                
                if (xa < xb)
                {
                    x1 = xa;
                    x2 = xb;
                    h1 = ha;
                    h2 = hb;
                }
                else
                {
                    x1 = xb;
                    x2 = xa;
                    h1 = hb;
                    h2 = ha;
                }

                long dx = x2 - x1;
                long sum = h1 + h2 + dx;
                long h_peak = sum / 2;

                if (h_peak < h[i])
                    continue;

                long peakNum = x1 + h1 + x2 - h2;
                long target = h[i];

                long left_x = x1 + h1 - target;
                if (left_x >= x1 && 2 * left_x <= peakNum && left_x != x[i])
                {
                    long dist = left_x - x[i];
                    if (dist < 0) dist = -dist;
                    if (dist < best)
                        best = dist;
                }

                long right_x = x2 - h2 + target;
                if (right_x <= x2 && 2 * right_x >= peakNum && right_x != x[i])
                {
                    long dist = right_x - x[i];
                    if (dist < 0) dist = -dist;
                    if (dist < best)
                        best = dist;
                }

                long peak_x = peakNum / 2;
                if (peak_x >= x1 && peak_x <= x2 && peak_x != x[i])
                {
                    long h_at_peak;
                    long diff_from_x1 = peak_x - x1;
                    long diff_from_x2 = peak_x - x2;
                    
                    if (diff_from_x2 <= 0)
                        h_at_peak = h1 - diff_from_x1;
                    else
                        h_at_peak = h2 + diff_from_x2;

                    if (h_at_peak >= h[i])
                    {
                        long dist = peak_x - x[i];
                        if (dist < 0) dist = -dist;
                        if (dist < best)
                            best = dist;
                    }
                }

                if (peakNum % 2 == 1)
                {
                    long peak_x_ceil = peakNum / 2 + 1;
                    if (peak_x_ceil >= x1 && peak_x_ceil <= x2 && peak_x_ceil != x[i])
                    {
                        long diff_from_x2 = peak_x_ceil - x2;
                        long h_at_peak_ceil = h2 + diff_from_x2;
                        
                        if (h_at_peak_ceil >= h[i])
                        {
                            long dist = peak_x_ceil - x[i];
                            if (dist < 0) dist = -dist;
                            if (dist < best)
                                best = dist;
                        }
                    }
                }

                if (x[i] > x1 && x[i] < x2)
                {
                    long h_at_i;
                    long two_xi = 2 * x[i];
                    
                    if (two_xi < peakNum)
                        h_at_i = h1 - (x[i] - x1);
                    else if (two_xi > peakNum)
                        h_at_i = h2 + (x[i] - x2);
                    else
                        h_at_i = h1 - (x[i] - x1);

                    if (h_at_i >= h[i])
                        best = 0;
                }
            }

            if (best == long.MaxValue)
                Console.WriteLine(-1);
            else
                Console. WriteLine(best);
        }
    }
}